#if NUNIT
using System;
using System.Net;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.UnitTests;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_VbecsBpsMessage : BaseTest
	{
		private const string TAS_TEST_ORDER = "1^TAS^99VBC^^";
		private const string KC_DIVISION = "589^VA HEARTLAND - WEST, VISN 15";

		private const string BLOOD_UNIT_AND_PATIENT_QUERY =  
			"SELECT TOP 1 BU.BloodUnitGuid, P.PatientGuid, UnitStatusCode, BU.EyeReadableUnitId, P.PatientSsn, P.VistaPatientId " +
			"FROM dbo.BloodUnit BU " +
			"JOIN dbo.BloodUnitStatusCodeCurrent BUSCC ON BU.BloodUnitGuid = BUSCC.BloodUnitGuid " +
			"JOIN dbo.OrderedUnit OU ON BU.BloodUnitGuid = OU.BloodUnitGuid " +
			"JOIN dbo.OrderedComponent OC ON OU.OrderedComponentGuid = OC.OrderedComponentGuid " +
			"JOIN dbo.PatientOrder PO ON OC.PatientOrderGuid = PO.PatientOrderGuid " +
			"JOIN dbo.PatientTreatment PT ON PO.PatientTreatmentGuid = PT.PatientTreatmentGuid " +
			"JOIN dbo.Patient P ON P.PatientGuid = PT.PatientGuid " +
			"WHERE UnitStatusCode IN ('S', 'C', 'I') ";

		private string _eyeReadableUnitId = string.Empty;
		private string _patientSsn = string.Empty;
		private string _vistaPatientId = string.Empty;
	
//		private HL7BPDispenseStatus _dispenseStatus;

		private bool _refreshData = true;

		private Guid _bloodUnitGuid = Guid.Empty;
		private Guid _patientGuid = Guid.Empty;

		[SetUp]
		protected void SetUp()
		{
			if (this._refreshData)
			{
				UnitTestUtil.RunSQL( "UPDATE InterfaceControl SET InterfaceActiveIndicator = 1 WHERE InterfaceControlId = 4" );
				//
				DataRow drSetupData = UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned(BLOOD_UNIT_AND_PATIENT_QUERY);
				if ( drSetupData == null || 
					drSetupData.IsNull("BloodUnitGuid") || 
					drSetupData.IsNull("PatientGuid") || 
					drSetupData.IsNull("UnitStatusCode") || 
					drSetupData.IsNull("EyeReadableUnitId") || 
					drSetupData.IsNull("PatientSsn") || 
					drSetupData.IsNull("VistaPatientId") )
				{
					// Ok ... no joy so we need to create some data
					DataCreator.CreateDirectedBloodUnit( Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid() );
					//
					// Try, try again
					drSetupData = UnitTestUtil.RunSQLGetDataRow(BLOOD_UNIT_AND_PATIENT_QUERY);
				}
				else
				{
					_bloodUnitGuid = (Guid)drSetupData["BloodUnitGuid"];
					_patientGuid = (Guid)drSetupData["PatientGuid"];
					_eyeReadableUnitId = drSetupData["EyeReadableUnitId"].ToString();
					_patientSsn = drSetupData["PatientSsn"].ToString();
					_vistaPatientId = drSetupData["VistaPatientId"].ToString();
					//
//					switch (drSetupData["UnitStatusCode"].ToString())
//					{
//						case "S":
//						case "C":
//						{
//							_dispenseStatus = HL7BPDispenseStatus.RS;
//							break;
//						}
//						case "I":
//						{
//							_dispenseStatus = HL7BPDispenseStatus.DS;
//							break;
//						}
//						default:
//						{
//							_dispenseStatus = HL7BPDispenseStatus.UK;
//							break;
//						}
//					}
				}

				this.BaseSetUp();

				this._refreshData = false;
			}
		}

		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
			Assert.IsNotNull( vbecsBpsMessage );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

//		[Test]
//		public void BceCotsInterfaceActivationUpdate_Pass()
//		{
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			//
//			Assert.IsTrue( vbecsBpsMessage.BceCotsInterfaceActivationUpdate() > 0 );
//		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void BceCotsInterfaceActivationUpdate_Fail()
		{
		}

//		[Test]
//		public void ConstructAndSendMessage_Pass()
//		{
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			//
//			vbecsBpsMessage.ConstructAndSendMessage( _bloodUnitGuid, _patientGuid, _dispenseStatus );
//			//
//			string query = "SELECT MessageLogId FROM MessageLog WHERE " +
//				"MessageStream LIKE '%" + _dispenseStatus.ToString().Trim() + "%' " +
//				"AND MessageStream LIKE '%" + _eyeReadableUnitId + "%' " +
//				"AND MessageStream LIKE '%" + _patientSsn + "%' " +
//				"AND MessageStream LIKE '%" + _vistaPatientId + "%' ";
//			//																			
//			DataRow drTest = UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned(query);
//			//
//			Assert.NotNull( drTest );
//			Assert.IsFalse( drTest.IsNull("MessageLogId") );
//		}

//		[Test]
//		[ExpectedException( typeof ( ArgumentException ) )]
//		public void ConstructAndSendMessage_Fail_One()
//		{
//			Guid bloodUnitGuid = Guid.Empty;
//			Guid patientGuid = Guid.Empty;  
//			HL7BPDispenseStatus dispenseStatus = HL7BPDispenseStatus.RS;
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			vbecsBpsMessage.ConstructAndSendMessage( bloodUnitGuid, patientGuid, dispenseStatus );
//		}

//		[Test]
//		[ExpectedException( typeof ( ArgumentException ) )]
//		public void ConstructAndSendMessage_Fail_Two()
//		{
//			Guid bloodUnitGuid = Guid.NewGuid();
//			Guid patientGuid = Guid.Empty;  
//			HL7BPDispenseStatus dispenseStatus = HL7BPDispenseStatus.RS;
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			vbecsBpsMessage.ConstructAndSendMessage( bloodUnitGuid, patientGuid, dispenseStatus );
//		}
//
//		[Test]
//		[ExpectedException( typeof ( ArgumentException ) )]
//		public void ConstructAndSendMessage_Fail_Three()
//		{
//			Guid bloodUnitGuid = Guid.Empty;
//			Guid patientGuid = Guid.NewGuid();
//			HL7BPDispenseStatus dispenseStatus = HL7BPDispenseStatus.RS;
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			vbecsBpsMessage.ConstructAndSendMessage( bloodUnitGuid, patientGuid, dispenseStatus );
//		}

//		[Test]
//		[ExpectedException( typeof ( HL7.OpenLibrary.HL7Exception ) )]
//		public void ConstructAndSendMessage_Fail_Four()
//		{
//			Guid bloodUnitGuid = Guid.NewGuid();
//			Guid patientGuid = Guid.NewGuid(); 
//			HL7BPDispenseStatus dispenseStatus = HL7BPDispenseStatus.RS;
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			vbecsBpsMessage.ConstructAndSendMessage( bloodUnitGuid, patientGuid, dispenseStatus );
//		}
//
//		[Test]
//		public void ConstructMessage_Pass()
//		{
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			//
//			DataTable dtTest = vbecsBpsMessage.ConstructMessage( _bloodUnitGuid, _patientGuid _dispenseStatus,  false );
//			//
//			Assert.NotNull( dtTest);
//			Assert.IsTrue( dtTest.Rows.Count > 0 );
//		}
//
//		[Test]
//		[ExpectedException( typeof ( ArgumentException ) )]
//		public void ConstructMessage_Fail()
//		{
//			Guid bloodUnitGuid = Guid.Empty;
//			Guid patientGuid = Guid.Empty;  
//			HL7BPDispenseStatus dispenseStatus = HL7BPDispenseStatus.RS;
//			VbecsBpsMessage vbecsBpsMessage = new VbecsBpsMessage();
//			vbecsBpsMessage.ConstructAndSendMessage( bloodUnitGuid, patientGuid, dispenseStatus );
//		}


	}
}
#endif